/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.MCLErrorIds;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BaseUpdateStarter
implements Runnable,
MCLErrorIds {
    private static final String TRACE_MASKT = "XMCLSTRT";
    private static final String TRACE_MASKF = "XMCLSTRF";
    private static final String TRACE_MASKD = "XMCLSTRD";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(2, "XMCL");

    public void run() {
        Trace.trace(TRACE_MASKT, "-> BaseUpdateStarter.run()");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                BaseUpdateStarter.this.processStart();
            }
        }, "Asynchronous processStart operation");
        thread.setDaemon(true);
        thread.start();
        Trace.trace(TRACE_MASKT, "<- BaseUpdateStarter.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processStart() {
        Trace.trace(TRACE_MASKT, "-> BaseUpdateStarter.processStart()");
        try {
            block19: {
                Manager.getManager().waitForTowers();
                String acceptListFile = "iqzmacpt.lst";
                String acceptListPath = " ";
                try {
                    acceptListPath = BaseFileControl.getFilePath("iqzmacpt.lst");
                }
                catch (HException hexc) {
                    this.logAndRethrowError("Could not find accept list =" + hexc, (short)-4078, hexc);
                }
                acceptListFile = acceptListPath + acceptListFile;
                BufferedReader instream = null;
                File acceptFile = new File(acceptListFile);
                Trace.trace(TRACE_MASKD, "acceptFile=" + acceptFile);
                if (acceptFile.exists()) {
                    ArrayList<UpdateLevel> levelsToProcess = new ArrayList<UpdateLevel>();
                    instream = new BufferedReader(new FileReader(acceptListFile));
                    String acceptListLine = instream.readLine();
                    Trace.trace(TRACE_MASKD, "acceptListLine=" + acceptListLine);
                    while (null != acceptListLine) {
                        StringTokenizer tokens = new StringTokenizer(acceptListLine, ".");
                        String acceptStream = tokens.nextToken();
                        String acceptId = tokens.nextToken();
                        int acceptLevel = Integer.parseInt(acceptId, 10);
                        Trace.trace(TRACE_MASKD, "acceptStream=" + acceptStream + "acceptLevel=" + acceptLevel);
                        UpdateLevel nextLevel = new UpdateLevel(acceptStream, acceptLevel);
                        levelsToProcess.add(nextLevel);
                        acceptListLine = instream.readLine();
                    }
                    Trace.trace(TRACE_MASKD, "levelsToProcess.size=" + levelsToProcess.size());
                    if (levelsToProcess.size() > 0) {
                        UpdateUtilities uu = new UpdateUtilities();
                        uu.commitAppliedCollections(levelsToProcess);
                    }
                    acceptFile.delete();
                    Object var13_17 = null;
                    try {
                        instream.close();
                    }
                    catch (IOException e2) {
                        this.logError("Error on close of accept list =" + e2, (short)-4079);
                    }
                    break block19;
                    {
                        catch (IOException e) {
                            this.logError("IO error =" + e, (short)-4080);
                            Object var13_18 = null;
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logError("Error on close of accept list =" + e2, (short)-4079);
                            }
                            break block19;
                        }
                        catch (HException e) {
                            this.logError("Error processing autoaccept =" + e, (short)-4077);
                            Object var13_19 = null;
                            try {
                                instream.close();
                            }
                            catch (IOException e2) {
                                this.logError("Error on close of accept list =" + e2, (short)-4079);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_20 = null;
                        try {
                            instream.close();
                        }
                        catch (IOException e2) {
                            this.logError("Error on close of accept list =" + e2, (short)-4079);
                        }
                        throw throwable;
                    }
                }
            }
            FcsServer server = FcsServer.getFcsServer();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            FcsServiceId serviceId = new FcsServiceId("QueryUpdateCollections", 1.0);
            server.addLocalService(serviceId, "com.ibm.hwmca.base.updates.QueryService");
        }
        catch (HException hexc) {
            this.logError("Error in processStart() " + hexc, (short)-4076, hexc);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdateStarter.processStart()");
    }

    private void logError(String errorString, short errorId) throws HException {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        HException hexc = new HException(errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        throw hexc;
    }

    protected void logError(String errorString, short errorId, Exception hexc) {
        Trace.trace(TRACE_MASKD, "-> logError()");
        Trace.trace(TRACE_MASKF, errorString);
        new FrameworkLog(logInfo, errorId, hexc).log();
        Trace.trace(TRACE_MASKD, "<- logError()");
    }

    protected void logAndRethrowError(String errorString, short errorId, Exception exc) throws HException {
        HException hexc = new HException(exc);
        this.logError(errorString, errorId, hexc);
        throw hexc;
    }
}

